// get_divisor initializes the divisor variable to the overall case
function divisor_init() {
    let status = { success: true, missing: [], invalid: [] };
    const showOverallPoints = get_variable_value(status, `SHOW_OVERALL_POINTS`);

    if (showOverallPoints === "true") {
        setOverallPoints();
    } else if (showOverallPoints === "false") {
        setLoadCasePoints();
    } else if (showOverallPoints === undefined) {
        setPointCalcVarFalse();
        setLoadCasePoints();
        // setLoadCasePoints();
    }

    // let divisor = 1;
    // let title = "Overall";
    // setScoreVars(divisor, title);
}

// USE_OVERALL_POINTS :: default -> false

function setPointCalcVarTrue() {
    let templ = Template.GetCurrent();
    new Variable(templ, `SHOW_OVERALL_POINTS`, `SHOW_OVERALL_POINTS`, "true", "String", false, false);

    setPointDivisor();
}

function setPointCalcVarFalse() {
    let templ = Template.GetCurrent();
    new Variable(templ, `SHOW_OVERALL_POINTS`, `SHOW_OVERALL_POINTS`, "false", "String", false, false);

    setPointDivisor();
}

function setPointDivisor() {
    let status = { success: true, missing: [], invalid: [] };

    const showOverallPoints = get_variable_value(status, `SHOW_OVERALL_POINTS`);
    // Window.Information("VAR VALUE", `This is the var value: ${loadCasePoints}`);
    if (showOverallPoints === "true") {
        setOverallPoints();
    } else if (showOverallPoints === "false") {
        setLoadCasePoints();
    } else if (showOverallPoints === undefined) {
        setLoadCasePoints();
    }
}

//Set True points is called by a button in reporter to change the calculation to the
// load case specific points rather than the overall
// the divisor is set to 2 because there are 2 validation cases, so when the scores
// from validation 1 and validation 2 are aggregated they create an overall score.
function setLoadCasePoints() {
    let divisor = 1;
    let title = "Load Case";
    let description =
        "Load-case points: point values in this report are presented for this load-case in isolation without applying a weighting of 1/3 for the contribution of this loadcase to the overall score.";
    let current = "The report is currently showing Load Case Points";
    setScoreVars(divisor, title, description, current);
}
//Set True points is called by a button in reporter to change the calculation to the
// Overall points rather than the Individual Load Case
function setOverallPoints() {
    let divisor = 3;
    let title = "Overall";
    let description =
        "Overall Points: point values in this report are presented with a weighting of 1/3 applied for the contribution of this loadcase to the overall score.";
    let current = "The report is currently showing Overall Points";
    setScoreVars(divisor, title, description, current);
}
// setScoreVars sets all of the variables that are related to the scores so that the
// reported points are correct, the max values for each category are correct, and the
// title used have the correct naming convention.
function setScoreVars(divisor, title, description, current) {
    let max_row = 0.625 / divisor;
    let max_total = 2.5 / divisor;
    let max_total_sum = 5 / divisor;
    let templ = Template.GetCurrent();

    new Variable(templ, `POINT_DIVISOR`, `Point divisor`, divisor.toString(), "String", false, true);
    new Variable(templ, `POINT_MAX_ROW`, `Point divisor`, max_row.toString(), "String", false, true);
    new Variable(templ, `POINT_MAX_TOTAL`, `Point divisor`, max_total.toString(), "String", false, true);
    new Variable(templ, `POINT_MAX_TOTAL_SUM`, `Point divisor`, max_total_sum.toString(), "String", false, true);
    new Variable(templ, `POINT_TITLE`, `Point divisor`, title, "String", false, true);
    new Variable(templ, `POINT_DESCRIPTION`, `Point description`, description, "String", false, true);
    new Variable(templ, `POINTS_CURRENT`, `POINTS_CURRENT`, current, "String", false, true);

    generate_item(`#AAW Scoring Script overall`);
}

divisor_init();
